<?php
/**
 * Dashboard API - Point Blank Royal
 * Endpoints administrativos para gerenciamento
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');

// Configuração
$host = 'localhost';
$user = 'seu_usuario';
$pass = 'sua_senha';
$db = 'pointblank_launcher';

$conn = mysqli_connect($host, $user, $pass, $db);
mysqli_set_charset($conn, 'utf8mb4');

$action = $_GET['action'] ?? $_POST['action'] ?? '';

switch ($action) {
    case 'get_stats':
        getStats($conn);
        break;
    
    case 'get_online_users':
        getOnlineUsers($conn);
        break;
    
    case 'get_detections':
        getDetections($conn);
        break;
    
    case 'get_bans':
        getBans($conn);
        break;
    
    case 'ban_user':
        banUser($conn);
        break;
    
    case 'unban_user':
        unbanUser($conn);
        break;
    
    case 'get_processes':
        getProcesses($conn);
        break;
    
    case 'get_user_history':
        getUserHistory($conn);
        break;
    
    default:
        echo json_encode(['error' => 'Invalid action']);
}

mysqli_close($conn);

function getStats($conn) {
    $result = $conn->query("SELECT * FROM quick_stats");
    $stats = $result->fetch_assoc();
    echo json_encode($stats);
}

function getOnlineUsers($conn) {
    $result = $conn->query("SELECT * FROM users_online LIMIT 100");
    $users = [];
    while ($row = $result->fetch_assoc()) {
        $users[] = $row;
    }
    echo json_encode(['users' => $users]);
}

function getDetections($conn) {
    $result = $conn->query("
        SELECT d.*, u.pc_name, u.username
        FROM process_detections d
        LEFT JOIN users u ON d.hwid = u.hwid
        WHERE d.detected_at > DATE_SUB(NOW(), INTERVAL 24 HOUR)
        ORDER BY d.detected_at DESC
        LIMIT 50
    ");
    
    $detections = [];
    while ($row = $result->fetch_assoc()) {
        $detections[] = $row;
    }
    echo json_encode(['detections' => $detections]);
}

function getBans($conn) {
    $result = $conn->query("
        SELECT b.*, u.pc_name, u.username
        FROM bans b
        LEFT JOIN users u ON b.hwid = u.hwid
        WHERE b.permanent = 1 OR b.banned_until > NOW()
        ORDER BY b.created_at DESC
    ");
    
    $bans = [];
    while ($row = $result->fetch_assoc()) {
        $bans[] = $row;
    }
    echo json_encode(['bans' => $bans]);
}

function banUser($conn) {
    $hwid = $_POST['hwid'] ?? '';
    $reason = $_POST['reason'] ?? 'Não especificado';
    $permanent = $_POST['permanent'] ?? 1;
    $admin = $_POST['admin'] ?? 'Admin';
    
    if (empty($hwid)) {
        echo json_encode(['success' => false, 'error' => 'HWID required']);
        return;
    }
    
    $banned_until = $permanent ? null : date('Y-m-d H:i:s', strtotime('+7 days'));
    
    $stmt = $conn->prepare("
        INSERT INTO bans (hwid, reason, banned_by, permanent, banned_until, created_at)
        VALUES (?, ?, ?, ?, ?, NOW())
    ");
    $stmt->bind_param("sssis", $hwid, $reason, $admin, $permanent, $banned_until);
    $stmt->execute();
    
    echo json_encode(['success' => true]);
}

function unbanUser($conn) {
    $hwid = $_POST['hwid'] ?? '';
    
    if (empty($hwid)) {
        echo json_encode(['success' => false, 'error' => 'HWID required']);
        return;
    }
    
    $stmt = $conn->prepare("DELETE FROM bans WHERE hwid = ?");
    $stmt->bind_param("s", $hwid);
    $stmt->execute();
    
    echo json_encode(['success' => true]);
}

function getProcesses($conn) {
    $hwid = $_GET['hwid'] ?? '';
    
    if (empty($hwid)) {
        echo json_encode(['error' => 'HWID required']);
        return;
    }
    
    $stmt = $conn->prepare("
        SELECT processes_list 
        FROM realtime_processes 
        WHERE hwid = ? 
        ORDER BY updated_at DESC 
        LIMIT 1
    ");
    $stmt->bind_param("s", $hwid);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        echo json_encode(['processes' => $row['processes_list']]);
    } else {
        echo json_encode(['processes' => null]);
    }
}

function getUserHistory($conn) {
    $hwid = $_GET['hwid'] ?? '';
    
    if (empty($hwid)) {
        echo json_encode(['error' => 'HWID required']);
        return;
    }
    
    // Info do usuário
    $stmt = $conn->prepare("SELECT * FROM users WHERE hwid = ?");
    $stmt->bind_param("s", $hwid);
    $stmt->execute();
    $user = $stmt->get_result()->fetch_assoc();
    
    // Sessões recentes
    $stmt = $conn->prepare("
        SELECT * FROM launcher_sessions 
        WHERE hwid = ? 
        ORDER BY started_at DESC 
        LIMIT 20
    ");
    $stmt->bind_param("s", $hwid);
    $stmt->execute();
    $sessions = [];
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $sessions[] = $row;
    }
    
    // Detecções
    $stmt = $conn->prepare("
        SELECT * FROM process_detections 
        WHERE hwid = ? 
        ORDER BY detected_at DESC 
        LIMIT 20
    ");
    $stmt->bind_param("s", $hwid);
    $stmt->execute();
    $detections = [];
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $detections[] = $row;
    }
    
    echo json_encode([
        'user' => $user,
        'sessions' => $sessions,
        'detections' => $detections
    ]);
}
?>
